'Clock Radio by Dan Amos. 
'Licenses under Attribution-NonCommercial-ShareAlike 3.0 Australia license
'http://creativecommons.org/licenses/by-nc-sa/3.0/au/

Dim MonthLookup(11) = (1,4,4,0,2,5,0,3,6,1,4,6)
Dim MonthNames$(11) = ("January","February","March","April","May","June","July","August","September","October","November","December")
Dim DayNames$(6) = ("Saturday","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday")

  Dim win(55,8) 'up to 43 windows with these attributes:
  '0 - left
  '1 - top
  '2 - width
  '3 - height
  '4 - parent window. 0 means no parent (eg dialog)
  '5 - type: 0 = dialog, 1 = button, 3 = edit, 4 = static
  '6 - value: 0 = normal, 1 = down, 2 = red, 3 = green, 4 = blue
  '7 - function code

  Dim wintext$(55) 'text associated with window

  Dim foreCol%, bkCol%, radCol%, alCol%, tempCol%, btnCol, btnSel
  Dim activewindow = 0, numwindows = 0
  'window handles
  Dim winMain, winStation, winNumeric, dp
  'statics
  Dim sTime, sPm, sDate, sTemp, sAlarm, sAlarmCapt, sAlarmType$, aAlarmPm, sRadioFreq, sRadioCapt, sStereo, sMHz, sStFreq
  'buttons
  Dim bOff, bRadio, bLine, bK1, bK2, bK3, bK4, bP1, bP2, bP3, bP4, bP5, bP6, bP7, bP8
  Dim bMem, sud = 128 'search up
  'levels
  Dim signal = 15, alarmHour = 12, alarmMinute = 0, freq = 105.7, stereo = 1
  Dim dbTimer% = 0, sSource$ = "Off"

  Dim touched = 0
  Dim As integer buf(10)
  Dim lastTime$
  Dim alarmOn = 0, alarmTone
  Dim ps1$="M1",ps2$="M2",ps3$="M3",ps4$="M4"
  Dim ps5$="M5",ps6$="M6",ps7$="M7",ps8$="M8"

start:
  initialize
  Do
    CheckTouch
    If Left$(Time$,5) <> lastTime$ Then UpdateClock 1
    CheckBrightness
    Pause 5
  Loop  'loop indefinitely - everything runs though interrupts

Sub initialize
  CLS
  RTC gettime
  SetPin 10,dout
  Pin(10) = 1
  SetPin 16,dout
  Pin(16) = 1 'pins 16 and 10 are source select: 00=radio, 01=line, 10=alarm
  SetPin 22,dout
  Pin(22)=0
  SetPin(5),ain
  VAR restore
  winMain = createwindow(0,0,320,240,0,0,0," ") 'mainwindow
  sTime = createwindow(1,1,310,87,winMain,4,110," ") 'Time
  sPM = createwindow(297,88,20,10,winMain,4,0," ")
  sDate = createWindow(140,93,180,20,winMain,4,113," ")
  bOff = createWindow(10,120,50,36,winMain,1,100,"Off")
  bRadio = createWindow(65,120,60,36,winMain,1,101,"Radio")
  bLine = createWindow(130,120,80,36,winMain,1,102,"Line In")
  sTemp = createWindow(270,120,70,36,winMain,4,0," ")
  sAlarm = createWindow(2,185,120,60,winMain,4,111," ")
  sRadioFreq = createWindow(187,160,140,60,winMain,4,112," ")

  winStation = createwindow(0,0,320,240,0,0,0," ") 'station selection window
  sStFreq = createWindow(80,1,140,45,winStation,4,215," ")
  x = createwindow(1,1,75,45,winStation,1,201,"Back")
  bMem = createwindow(240,1,77,45,winStation,1,202,"Memory")
  bP1 = createwindow(0,73,77,45,winStation,1,203,ps1$)
  bP2 = createwindow(80,73,77,45,winStation,1,204,ps2$)
  bP3 = createwindow(160,73,77,45,winStation,1,205,ps3$)
  bP4 = createwindow(240,73,77,45,winStation,1,206,ps4$)
  bP5 = createwindow(0,121,77,45,winStation,1,207,ps5$)
  bP6 = createwindow(80,121,77,45,winStation,1,208,ps6$)
  bP7 = createwindow(160,121,77,45,winStation,1,209,ps7$)
  bP8 = createwindow(240,121,77,45,winStation,1,210,ps8$)
  x = createwindow(0,192,77,45,winStation,1,211,"88")
  x = createwindow(80,192,77,45,winStation,1,212,"Down")
  x = createwindow(160,192,77,45,winStation,1,213,"Up")
  x = createwindow(240,192,77,45,winStation,1,214,"108")

  winNumeric = createwindow(0,0,320,240,0,0,0," ") 'winNumeric dialog. Window 22
  x = createwindow(1,1,47,58,winNumeric,1,307,"7")
  x = createwindow(51,1,47,58,winNumeric,1,308,"8")
  x = createwindow(101,1,47,58,winNumeric,1,309,"9")
  x = createwindow(1,61,47,58,winNumeric,1,304,"4")
  x = createwindow(51,61,47,58,winNumeric,1,305,"5")
  x = createwindow(101,61,47,58,winNumeric,1,306,"6")
  x = createwindow(1,121,47,58,winNumeric,1,301,"1")
  x = createwindow(51,121,47,58,winNumeric,1,302,"2")
  x = createwindow(101,121,47,58,winNumeric,1,303,"3")
  x = createwindow(1, 181, 47,57,winNumeric,1,300,"0")
  dp = createwindow(51,181,47,57,winNumeric,1,310,".")
  x = createwindow(101,181,47,57,winNumeric,1,311,"C")
  bK1 = createwindow(160,100,78,43,winNumeric,1,312,"Radio")
  bK2 = createwindow(240,100,78,43,winNumeric,1,313,"Line")
  bK3 = createwindow(160,145,78,43,winNumeric,1,315,"Buzz")
  bK4 = createwindow(240,145,78,43,winNumeric,1,316,"Off")
  x = createwindow(160,195,78,43,winNumeric,1,398,"Cancel")
  x = createwindow(240,195,78,43,winNumeric,1,399,"OK")
  winNumericStatic = createwindow(165,1,70,24,winNumeric,4,0,"Frequency") 'Static
  winNumericEdit = createwindow(160,30,150,20,winNumeric,3,0,"0") 'Edit
  foreCol% = RGB(white)
  bkCol% = RGB(0,80,116)
  radCol% = RGB(89,209,244)
  alCol% = RGB(210,100,244)
  tempCol% = RGB(yellow)
  btnCol = 170
  btnSel = 230
  sAlarmType$ = "Radio"
  win(bOff,6)=4
  PWM 2,1000,100
  DoNormal 'display normal window
'  shownumpad sTime,"Enter Time"
' DoRadio
End Sub

Function CreateWindow(lft, top, width, height, parent, type, funct, windowtext$)
  numwindows = numwindows + 1
  '  print "Creating window " numWindows " " lft "," top ": " width "x" height
  win(numwindows,0) = lft
  win(numwindows,1) = top
  win(numwindows,2) = width
  win(numwindows,3) = height
  win(numwindows,4) = parent
  win(numwindows,5) = type
  win(numwindows,6) = 0
  win(numwindows,7) = funct
  wintext$(numwindows) = windowtext$
  createwindow = numwindows
End Function

Sub DrawWindow id, clr
  'draws window and child windows. If clr is 1, background is cleared
  If win(id,4) <> 0 Then Exit Sub
  Font #1,1
  If clr<>0 Then CLS bkcol%
  activewindow = id
  'draw children
  For i = 1 To numwindows
    'print "Draw window " i ", parent is " win(i,4) " window type is " win(i,5)
    If win(i,4) = id Then
      If win(i,5) = 1 Then
        DrawButton(i)
      ElseIf win(i,5) = 3 Then
        DrawEdit(i, 1)
      ElseIf win(i,5) = 4 Then
        DrawStatic(i)
    ElseIf win(i,5) = 5 Then
    DrawLevel(i)
      EndIf
    EndIf
  Next i
End Sub

Sub DrawButton b
  Local c = btnCol
  Local cr = btnSel
  col = RGB(c,c,c)
  If win(b,6) = 2 Then 'red
    col = RGB(cr,c,c)
  ElseIf win(b,6) = 3 Then 'green
    col = RGB(c,cr,c)
  ElseIf win(b,6) = 4 Then 'blue
    col = RGB(c,c,cr)
  EndIf
  RBox win(b,0),win(b,1),win(b,2),win(b,3),2,col,col
  Text win(b,0) + win(b,2) / 2, win(b,1) + win(b,3) / 2, wintext$(b), CM,1,1, foreCol%,col
End Sub

Sub DrawEdit b, clr
  If clr <> 0 Then
    Box win(b,0),win(b,1),win(b,2),b(b,3),2,radCol%,RGB(btnCol,btnCol,btnCol)
  EndIf
   Text win(b,0) + 3,win(b,1) + (win(b,1) + win(b,3)) / 2,wintext$(b),LM,1,2,foreCol%,RGB(btnCol,btnCol,btnCol)
End Sub

Sub DrawLevel b
  Local i
  For i = 0 To win(b,6)
    Box win(b,0) + i * 20, win(b,1), 16, 10,1, RGB(blue), RGB(blue)
  Next i
End Sub

Sub DrawStatic b
  Text win(b,0) + win(b,2) / 2, win(b,1) + win(b,3) / 2, wintext$(b), CM,,1,foreCol%,bkCol%
End Sub

Sub CheckTouch
  'processes touch interrupts
  'checks all buttons on active window to determine if one is being touched
  x = Touch(x)
  y = Touch(y)
  If alarmOn = 1 And x >= 0 Then
    TurnAlarmOff
    dbTimer% = Timer
    Exit Sub
  EndIf
  For i = 1 To numwindows
    If win(i,4) = activewindow And win(i,7) > 0 Then 'parent window visible and event handler
      If (x >= win(i,0) And x <= win(i,0) + win(i,2) And y >= win(i,1) And y <= win(i,1) + win(i,3)) Then
        touched = 100
        ButtonHit(i,x,y)
        Exit Sub
      EndIf
    EndIf
  Next i
End Sub

Sub ButtonHit btn,x,y
  'process button hit event. May need some debounce capability
  If Timer - dbTimer% < 200 Then Exit Sub
  dbTimer% = Timer
  Local b = win(btn,7)
  Print "Button hit " btn " command " b
  Select Case b
  Case 100 'Off
    SetSource btn
  Case 101 'Radio
    SetSource btn
  Case 102 'Line In
    SetSource btn
  Case 110 'Time
    shownumpad 1000,"Enter Time"
  Case 111 'Alarm
    shownumpad 1001,"Alarm Time"
  Case 112 'Freq
    If sSource$ = "Radio" Then DoRadio
  Case 113 'Date
    shownumpad 2000,"Enter Date"
  Case 201 'Back
    DoNormal
  Case 202 'Auto
    If win(bMem,6) = 4 Then
      win(bMem,6) = 0
    Else
      win(bMem,6) = 4
    EndIf
    DrawButton(bMem)
  Case 203
    Preset btn
  Case 204
    Preset btn
  Case 205
    Preset btn
  Case 206
    Preset btn
  Case 207
    Preset btn
  Case 208
    Preset btn
  Case 209
    Preset btn
  Case 210
    Preset btn
  Case 211 '88
    freq = 88
    sud = 128
    TuneRadio
    DoRadioFreq
  Case 212 'Down
    freq = freq - 0.2
    sud = 0
    If freq < 88 Then freq = 88
    TuneRadio
    DoRadioFreq
  Case 213 'Up
    freq = freq + 0.2
    sud = 128
    If freq > 108 Then freq = 108
    TuneRadio
    DoRadioFreq
  Case 214 'Seek Up
    freq = 108
    sud = 0
    TuneRadio
    DoRadioFreq
  Case 215 'Freq edit
    sud = 0
    shownumpad 215,"Frequency"
  Case 300 '0
    Digit btn
  Case 301 '1
    Digit btn
  Case 302 '2
    Digit btn
  Case 303 '3
    Digit btn
  Case 304 '4
    Digit btn
  Case 305 '5
    Digit btn
  Case 306 '6
    Digit btn
  Case 307 '7
    Digit btn
  Case 308 '8
    Digit btn
  Case 309 '9
    Digit btn
  Case 310 '.
    Digit btn
  Case 311 'C
    ClearEntry
  Case 312 'Radio
    AlarmMode bK1
  Case 313 'Line
    AlarmMode bK2
  Case 315 'Buzzer
    AlarmMode bK3
  Case 316 'Off
    AlarmMode bk4
  Case 398 'Cancel
    DoNormal
  Case 399 'Ok
    SetValue
  Case Else
  'default handler
  End Select

End Sub

Sub Shownumpad b, txt$
  'display numpad dialog
  numpadField = b
  wintext$(winNumericStatic) = txt$
  wintext$(winNumericEdit) = "0"
  Local msb = b \ 1000
  Print "Shownumpad" b "," msb "," txt$
  wintext$(dp) = "."
  If msb = 1 Then
    wintext$(dp) = ":"
  EndIf
  If msb = 2 Then
    wintext$(dp) = "/"
  EndIf
  If b = 1001 Then
    win(bK1, 5) = 1
    win(bK2, 5) = 1
    win(bK3, 5) = 1
    win(bK4, 5) = 1
  Else
    win(bK1, 5) = 0
    win(bK2, 5) = 0
    win(bK3, 5) = 0
    win(bK4, 5) = 0
  EndIf
  DrawWindow winNumeric, 1
End Sub

'set value of appropriate field
Sub SetValue
  Print "Set Value " numpadField ": " wintext$(winNumericEdit)
  Local h = 0, m = 0, s = 0, p, p2
  Local t$ = wintext$(winNumericEdit)
  Local n$
  If numpadField = 1000 Or numpadField = 1001 Then
    p = Instr(1, t$,":")
    If p > 1 Then
      n$ = Left$(t$, p - 1)
      h = Val(n$)
      p2 = Instr(p + 1, t$, ":")
       If p2 = 0 Then
        n$ = Mid$(t$,p+1)
        m = Val(n$)
      Else
        n$ = Mid$(t$,p+1, p2 - p -1)
        m = Val(n$)
        n$ = Mid$(t$,p2 + 1)
        s = Val(n$)
      EndIf
    EndIf
    t$ = ""
    If h < 10 Then t$ = "0"
    t$ = t$ + Str$(h) + ":"
    If m < 10 Then t$ = t$ + "0"
    t$ = t$ + Str$(m) + ":"
    If s < 10 Then t$ = t$ + "0"
    t$ = t$ + Str$(s)
    If numpadField = 1000 Then
      Print "Set time: " t$
      Time$ = t$
      SaveTime
    Else
      Print "Set alarm: " t$
      alarmHour = h
      alarmMinute = m
      VAR save alarmHour, alarmMinute
    EndIf
  EndIf
  If numpadField = 2000 Then 'date
    s = Val(Right$(Date$,2))
    p = Instr(1, t$,"/")
    If p > 1 Then
      n$ = Left$(t$, p - 1)
      h = Val(n$)
      p2 = Instr(p + 1, t$, "/")
       If p2 = 0 Then
        n$ = Mid$(t$,p+1)
        m = Val(n$)
      Else
        n$ = Mid$(t$,p+1, p2 - p -1)
        m = Val(n$)
        n$ = Mid$(t$,p2 + 1)
        s = Val(n$)
      EndIf
    EndIf
    t$ = ""
    If h < 10 Then t$ = "0"
    t$ = t$ + Str$(h) + "-"
    If m < 10 Then t$ = t$ + "0"
    t$ = t$ + Str$(m) + "-20"
    If s > 99 Then s = s Mod 100
    If s < 10 Then t$ = t$ + "0"
    t$ = t$ + Str$(s)
    Print "Set date " t$
    Date$ = t$
    SaveTime
  EndIf
  If numpadField = 215 Then 'frequency
    freq= Val(t$)
    sud = 128
    TuneRadio
    DoRadio
  Else
    DoNormal
  EndIf
End Sub

Sub Preset p
  If win(bMem,6) = 4 Then 'assign preset
  Print freq
    Local f$ = Str$(freq)
    wintext$(p) = f$
    Print wintext$(p)
    DrawButton p
    win(bMem,6) = 0
    DrawButton bMem
    Select Case p
    Case bP1
      ps1$ = f$
    Case bP2
      ps2$ = f$
    Case bP3
      ps3$ = f$
    Case bP4
      ps4$ = f$
    Case bP5
      ps5$ = f$
    Case bP6
      ps6$ = f$
    Case bP7
      ps7$ = f$
    Case bp8
      ps8$ = f$
    End Select
    VAR save ps1$,ps2$,ps3$,ps4$,ps5$,ps6$,ps7$,ps8$
  Else 'callup preset
    freq = Val(wintext$(p))
    TuneRadio
    DoRadioFreq
  EndIf
End Sub

Sub Digit b
  Local d$ = wintext$(b)
  Print "Digit text " d$
  Local w$ = wintext$(winNumericEdit)
  If Len(w$) > 8 Then Exit Sub
  If w$ = "0" Then w$ = ""
  UpdateEdit winNumericEdit, w$ + d$
End Sub

Sub ClearEntry
  wintext$(winNumericEdit) = "0"
  DrawEdit winNumericEdit, 1
End Sub

Sub UpdateEdit ed, t$
  wintext$(ed) = t$
  DrawEdit ed, 0
End Sub

Sub AlarmMode b
  Print "Alarm mode" b "," wintext$(b)
  win(bK1,6) = 0
  win(bK2,6) = 0
  win(bK3,6) = 0
  win(bK4,6) = 0
  win(b,6) = 4
  DrawButton bK1
  DrawButton bK2
  DrawButton bK3
  DrawButton bK4
  sAlarmType$ = wintext$(b)
  VAR save sAlarmType$
End Sub

Sub SetSource b
  Print "Set Source " b "," wintext$(b)
  win(bOff,6) = 0
  win(bRadio,6) = 0
  win(bLine,6) = 0
  win(b, 6) = 4
  DrawButton BOff
  DrawButton BRadio
  DrawButton BLine
  SetInput b
  sSource$ = wintext$(b)
  PrintFreq
End Sub

Sub SetInput b
  If b = bOff Then
    Pin(16) = 1
    Pin(10) = 1
    Pin(22) = 0
  Else If b = bRadio Then
    Pin(16) = 0
    Pin(10) = 0
    Pin(22) = 1
    TuneRadio
  Else If b = bLine Then
    Pin(16) = 1
    Pin(10) = 0
    Pin(22) = 1
  Else
    Pin(16) = 0
    Pin(10) = 1
    Pin(22) = 1
  EndIf
End Sub

Sub DoNormal
  DrawWindow winMain,1
  UpdateClock 0
  PrintDate
  PrintAlarm
  PrintFreq
End Sub

Sub DoRadio
  DrawWindow winStation,1
  DoRadioFreq
End Sub

Sub DoRadioFreq
  Local f$="   " + Str$(Int(freq))
  f$ = Right$(f$,3)
  Text 190,1,f$,rt,8,1,radCol%,bkCol%
  f$ = Str$(Int(freq * 10) Mod 10)
  Text 200,1,f$,lt,8,1,radCol%,bkCol%
  Circle 195,47,2,1,1,radCol%,radcol%
End Sub

Sub TuneRadio
  Print "Tune radio: " freq " SUD: " sud
  Local fb = 4 * (freq * 1000000 + 225000) / 32768
  Local fh = (fb >> 8) Or &h40
  Local fl = fb And &hff
  Print fb, fh, fl
  I2C open 100,1000
  I2C write &h60,0,5,fh,fl,sud Or &h70,&h16,0
  Pause 500
  I2C read &h60, 0, 5, buf()
  I2C close
  Print buf(0),buf(1),buf(2),buf(3)
  signal = buf(3) >> 4
  fh = buf(0) And &h3f
  fl = buf(1)
  fb = fh << 8 Or fl
  Local f = (fb * 32768 / 4) - 225000
  Print fb, fh, fl, f/1000000
  freq = Cint(f / 100000) / 10
  Print freq
  VAR save freq
End Sub

'returns Day of week for given date in 2000-2099 range as text
Function DayOfWeek$(d,m,y)
  Local dow = 0
  Local d2 = y Mod 100
  Local d4 = Int(d2 / 4)
  Local dom = d4 + d
  Local ml = MonthLookup(m - 1)
  Local ma = dom + ml
  Local isleap = 0
  If (y Mod 4 = 0) Then isleap = 1
  Local jf = 0
  If (isleap = 1 And m < 3) Then jf = -1
  Local ajf = ma + ajf + 6 'fixed factor for 2000-2099
  Local ay = ajf + d2
  dow = ay Mod 7
  DayOfWeek$ = DayNames$(dow)
End Function

Function GetDate$()
  Local d, m, y
  d = Val(Left$(Date$,2))
  m = Val(Mid$(Date$,4,2))
  y = Val(Right$(Date$,4))
  GetDate$ = DayOfWeek$(d,m,y) + ", " + Str$(d) + " " + MonthNames$(m - 1)+ " " + Str$(y)
End Function

Sub SaveTime
  Local d, m, y, h, min, s
  d = Val(Left$(Date$,2))
  m = Val(Mid$(Date$,4,2))
  y = Val(Right$(Date$,2))
  h = Val(Left$(Time$,2))
  min = Val(Mid$(Time$,4,2))
  s = Val(Right$(Time$,2))
  RTC settime y,m,d,h,min,s
End Sub

'Updates the clock display and housekeeping that gets done once per minute
Sub UpdateClock c
  Print "Update time: " Time$
  lastTime$ = Left$(Time$,5)
  Local h = Val(Left$(lastTime$,2))
  Local m = Val(Right$(lastTime$,2))
  Local h2 = h
  If h2 > 12 Then h2 = h2 - 12
  If h2 = 0 Then h2 = 12
  If activeWindow = winMain Then
    t$ = Str$(h2)
    If h2 < 10 Then t$ = " " + t$
    Font #8,2

    Text 135,1,t$,rt,8,2,foreCol%,bkCol%
    t$ = Str$(m)
    If m < 10 Then t$ = "0" + t$
    Text 291,1,t$,rt,8,2,forecol%,bkcol%
    Local a$ = "AM"
    If h > 11 Then a$ = "PM"
    Text 315,86,a$,rt,1,1,forecol%,bkcol%
    Circle 150,35,5,1,1,foreCol%,foreCol%
    Circle 150,70,5,1,1,forecol%,forecol%

    If (m = 0) Then StartOfHour(h)
    CheckTemperature
  EndIf
  If h = alarmHour And m = alarmMinute And c = 1 Then TurnAlarmOn
End Sub

Sub TurnAlarmOn
  alarmOn = 1
  Print "Alarm On"
  Select Case sAlarmType$
    Case "Off"
      SetInput bOff
    Case "Radio"
      SetInput bRadio
      PrintFreq
    Case "Line"
      SetInput bLine
    Case "Buzz"
      SetInput 0
      PWM 1,880,50
      alarmTone = 1
      SetTick 500,AlarmToneTimer
  End Select
End Sub

Sub AlarmToneTimer
  If alarmOn = 0 Then
    PWM 1,stop
    SetTick 0,0
  EndIf
  If alarmTone = 1 Then
    PWM 1,stop
    alarmTone = 0
  Else
    PWM 1,880,50
    alarmTone = 1
  EndIf
End Sub

Sub TurnAlarmOff
  alarmOn = 0
  Print "Alarm Off"
  SetInput bOff
  SetTick 0,0
End Sub

'Functions that run at the start of a new hour
Sub StartOfHour(h)

'if day changes, update date value
  If (h = 0) Then
    PrintDate
  End If
End Sub

Sub PrintDate
  Local g$ = "     " + getdate$()
  Print g$
  Text 315,102,g$,rt,1,1,forecol%,bkcol%
End Sub

Sub PrintAlarm
  Text 7,162,"ALARM",lt,1,1,alCol%,bkCol%
  If sAlarmType$ = "Off" Then
    Text 10,180,"Off",lt,1,4,alCol%,bkCol%
    Exit Sub
  EndIf
  Local a$ = Str$(alarmMinute)
  If alarmMinute < 10 Then a$ = "0" + a$
  Text 145,180,a$,rt,8,1,alCol%,bkCol%
  Local h = alarmHour
  If h > 12 Then h = h - 12
  a$ = Str$(h)
  Text 65,180,a$,rt,8,1,alCol%,bkCol%
  Circle 73,195,2,1,1,alCol%,alCol%
  Circle 73,212,2,1,1,alCol%,alCol%
  a$ = "AM"
  If alarmHour > 11 Then a$ = "PM"
  Text 145,217,a$,lt,1,1,alCol%,bkCol%
  Text 150,162,sAlarmType$,rt,1,1,alCol%,bkCol%
End Sub

Sub PrintFreq
  If activeWindow = winmain Then
    Box 162,160,158,80,1,bkCol%,bkCol%
    If sSource$ = "Radio" Then
      Local f$=Str$(Int(freq))
      Text 260,180,f$,rt,8,1,radCol%,bkCol%
      f$ = Str$(Int(freq * 10) Mod 10)
      Text 270,180,f$,lt,8,1,radCol%,bkCol%
      Circle 266,224,2,1,1,radCol%,RGB(0,0,192)
      Text 318,226,"MHz",rt,1,1,radCol%,bkCol%
      Box 175,233,1 + signal * 6,3,1, radCol%,radCol%
      If stereo = 1 Then Text 302,162,"STEREO",rt,1,1,radcol%,bkCol%
    Else
      Local a$ = sSource$
      If a$ <> "Off" Then a$ = "Line In"
      Text 310,210,a$,rt,1,2,radCol%,bkCol%
    EndIf
  EndIf
End Sub

'gets LDR value and adjusts LCD backlighting accordingly
'if radio is running also adjust signal strength indication
Sub CheckBrightness
  If activeWindow = winMain And sSource$ = "Radio" Then
    I2C open 100,1000
    I2C read &h60,0,5,buf()
    I2C close
    Local s = buf(3) >> 4
    signal = s
    If buf(2) And 128 <> 0 Then
      stereo = 1
      Text 302,162,"STEREO",rt,1,1,radcol%,bkCol%
    Else
      stereo = 0
      Box 250,162,50,10,1,bkcol%,bkcol%
    EndIf
    Box 175,233,1 + signal * 6,3,1, radCol%,radCol%
    If signal < 15 Then
      Box 176 + signal * 6,233,(15 - signal) * 6,3,1,RGB(black),RGB(black)
    EndIf
'    Print "Signal " signal ", stereo " stereo
  EndIf
  Local p5=100 - (Pin(5) * 50)
  If touched > 0 Then
    If p5 < 30 Then p5 = 30
    touched = touched - 1
  EndIf
  If p5 > 80 Then p5 = 100
  If p5 < 1 Then p5 = 1
  PWM 2,1000,p5
End Sub

Sub CheckTemperature
 If activeWindow = winMain Then
    I2C open 10,1000
    I2C write &h68,0,1,17
    I2C read &h68,0,2,buf()
    I2C close
    Local t = buf(0)
    If buf(1) And 128 Then t = t + 0.5
    Print "Temp: " t
    Text 304,125,Str$(t,2,1),rt,1,2,tempCol%,bkCol%
    Circle 310,130,2,1,1,tempCol%,bkCol%
  EndIf
End Sub

' ArialNumFontPlus.bas
DefineFont #8
  0B303220 00000000 00000000 00F00F00 00F81F00 00FE7F00 00FFFF00 00FFFF01
  801FF803 C00FF003 C007E007 E003C007 E003C00F F001800F F001800F F001801F
  F800001F F800001F F800001F F800001F FC00003F 7C00003E 7C00003E 7C00003E
  7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003F
  F800001F F800001F F800001F F800001F F001800F F001800F F001800F E003C007
  E003C007 C007E003 C00FF003 801FF801 00FFFF00 00FEFF00 00FC7F00 00F81F00
  00E00700 00000000 00000000 00000000 00000000 00000000 00F00000 00F00100
  00F00300 00F00700 00F00F00 00F01F00 00F03F00 00F07F00 00F0FF01 00F0FD03
  00F0F10F 00F0E10F 00F0810F 00F0010F 00F0010C 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00000000 00000000 00000000 00000000 00F00F00
  00FE7F00 00FFFF01 C0FFFF03 E0FFFF03 F00FE007 F003C00F F001800F F800001F
  F800001F F800003E 7C00003E 7C00003E 7C000000 7C000000 7C000000 78000000
  F8000000 F8010000 F0030000 F0070000 E00F0000 C01F0000 803F0000 007F0000
  00FE0000 00FC0100 00F80300 00F00700 00E00F00 00C01F00 00803F00 00007F00
  0000FE00 0000FC01 0000F803 0000F007 0000E007 0000C00F 0000800F 0000801F
  FCFFFF3F FCFFFF3F FCFFFF7F FCFFFF7F FCFFFF7F 00000000 00000000 00000000
  00000000 00F00F00 00FC3F00 00FEFF00 00FFFF01 80FFFF03 C01FE003 C00FC007
  E0078007 E003800F E003000F F003000F F001000F F0030000 E0030000 E0030000
  E0070000 C00F0000 C01F0000 803F0000 00FF0700 00FF0700 00FF0700 80FF0700
  C01F0000 E00F0000 E0030000 F0010000 F0000000 F8000000 F8000000 FC000000
  FC000000 FC000000 FC00001F FC00001F F800001F F801001F F801800F F003800F
  F007C00F E00FE007 C03FFC03 80FFFF01 00FFFF00 00FC7F00 00F00F00 00000000
  00000000 00000000 00000000 000F0000 001F0000 001F0000 003F0000 003F0000
  007F0000 007F0000 00FF0000 00FF0100 00FF0100 00FF0300 00DF0700 00DF0700
  009F0F00 009F0F00 001F1F00 001F3E00 001F7E00 001F7C00 001FF800 001FF800
  001FF001 001FE003 001FE003 001FC007 001FC007 001F800F 001F801F 001F001F
  001F003E FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F 001F0000 001F0000
  001F0000 001F0000 001F0000 001F0000 001F0000 001F0000 001F0000 001F0000
  001F0000 00000000 00000000 00000000 00000000 F0FFFF01 F0FFFF01 F0FFFF01
  F0FFFF01 F0FFFF01 0000E003 0000C003 0000C003 0000C003 0000C007 0000C007
  0000C007 0000C007 00008007 0000800F 00F0800F 00FE8F0F 80FFBF0F C0FFFF0F
  E0FFFF0F F007FF1F F003E01F F801C01F F800001F F8000000 FC000000 7C000000
  7C000000 7C000000 7C000000 7C000000 7C000000 7C000000 F800003F F800003F
  F800003F F000001F F001001F E003801F E007C00F C01FE007 80FFFF03 00FFFF03
  00FEFF01 00F87F00 00E00F00 00000000 00000000 00000000 00000000 00F00F00
  00FE3F00 00FFFF00 80FFFF01 C0FFFF03 E007E007 F003C007 F001C00F F800800F
  F800801F F800801F 0000001F 0000001F 0000003F 0000003F 0000003F 00F0033F
  00FC1F3F 00FE7F3F 80FFFF3F C0FFFF3F E00FF83F F003E03F F003E03F F801C03F
  F800803F F800803F 7C00003F 7C00003F 7C00003F 7C00003F 7C00003F 7C00003F
  7C00001F 7800801F F800801F F800801F F800800F F001C00F F003F007 E00FF803
  C0FFFF01 80FFFF00 00FF7F00 00FC1F00 00F00300 00000000 00000000 00000000
  00000000 FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FC000000 FC000000
  F8010000 F0010000 E0030000 E0030000 C0070000 800F0000 001F0000 003E0000
  007C0000 00FC0000 00F80000 00F00000 00F00100 00F00100 00E00300 00E00300
  00E00300 00C00700 00C00700 00800F00 00800F00 00800F00 00001F00 00001F00
  00001F00 00001F00 00003E00 00003E00 00003E00 00003E00 00003E00 00007C00
  00007C00 00007C00 00007C00 00007C00 0000F800 0000F800 0000F800 00000000
  00000000 00000000 00000000 00F00F00 00FE7F00 80FFFF00 80FFFF01 C01FF803
  E007E007 E003C007 F003C00F F001800F F001800F F001800F F001800F F001800F
  F001800F E003C007 E003C007 C007E003 8007F001 003FFC00 00FF7F00 00FC3F00
  00FE7F00 00FFFF00 C0FFFF03 E00FF007 F003C00F F001800F F801801F F800001F
  F800001F 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E F800001F
  F800001F F001800F F003800F E007C007 C00FF003 80FFFF01 00FFFF00 00FC3F00
  00F00F00 00000000 00000000 00000000 00000000 00F00F00 00FC3F00 00FFFF00
  80FFFF01 C0FFFF03 E01FF803 E007E007 F007E007 F003C00F F803C00F F801801F
  F801801F FC00001F FC00001F FC00001F FC00001F FC00001F FC00001F FC01801F
  FC01801F FC03C00F FC03C00F FC07E007 FC07E007 FC1FF803 FCFFFF01 FCFFFF00
  FCFEFF00 FCF87F00 FCE01F00 FC000000 FC000000 FC000000 FC000000 F8010000
  F801003F F001003F F003001F E007801F E00FC00F C03FE00F 80FFFF07 00FFFF03
  00FEFF01 00F8FF00 00E03F00 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00E00000 00F00100 00F80300 00F80300 00F80300 00F00100 00E00000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00E00000 00F00100
  00F80300 00F80300 00F80300 00F00100 00E00000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000
End DefineFont                                                                                                                 